/*
Copyright © 2005, ladybug.fr.  All rights reserved.
HTML, CSS & JavaScript : Fabrice Delaneau & Benoit Pepermans
Graphics : Fabrice Delaneau

http://www.ladybug.fr/goodies.html

http://www.ladybug.fr/ladytax
----------------------------------------------------------------------------------------------

Creative Commons Licence
----------------------------------------------------------------------------------------------
This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike License.
To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/2.0/
or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
*/

var userEntry = "";
var direction = "left";
var storedRates = "";
var selectedRow = null;

var allRates = [{label:"TVA", percent:"19.6"}, {label:"TVA réduite", percent:"5.5"}, {label:"TVA réduite", percent:"2.10"}];
var chosenRate = 0;

function setup() {

	if (window.widget) {
		document.getElementById('left').setAttribute("placeholder", getLocalizedString('exVAT'));
		document.getElementById('right').setAttribute("placeholder", getLocalizedString('incVAT'));
		
		document.getElementById('input-label').setAttribute("placeholder", getLocalizedString('Name'));
		document.getElementById('input-rate').setAttribute("placeholder", getLocalizedString('Rate'));
		
		chosenRate = widget.preferenceForKey(createKey("chosenRate"));
		chosenRate = (!chosenRate || chosenRate.length == 0) ? 0 : chosenRate;

		var storedRates = widget.preferenceForKey("storedRates");
		allRates = (!storedRates || storedRates.length == 0) ? allRates : eval(storedRates);
		
	}
	
	setRatesTable();
	listRates(chosenRate);
	applyRate();
}

function writePercentLabel(val) {
	return val+" %";
}

function applyRate() {
	var taxList = document.getElementById('taxrate-menu');
	chosenRate = taxList.options[taxList.selectedIndex].value;

		if (window.widget) {
		widget.setPreferenceForKey(chosenRate, createKey("chosenRate"));
	}

	document.getElementById('taxrate-label').innerText = writePercentLabel(allRates[chosenRate].percent);
	upValue(userEntry, direction);
}

function listRates(sel) {
	var taxList = document.getElementById('taxrate-menu');

	taxList.options[0] = null;
	
	for (var i=0; i<allRates.length; i++) {
		var data = allRates[i];
		var opt = new Option(writePercentLabel(data.percent)+" - "+data.label, i);
		taxList.options[i] = opt;
	}
	if ((sel) && (sel < allRates.length)) {
		taxList.options[sel].selected = true;
	}
	else {
		taxList.options[0].selected = true;
	}
}


function upValue(amount, side) {
	var calcValue = taxAmount = "";	
	var operation = (side == "right") ? "/" : "*";
	var calc = (side == "left") ? document.getElementById('right') : document.getElementById('left');
	
	var tax = document.getElementById('taxamount');
	var floatValue = amount.replace(',', '.');
		
	if (!floatValue) {
		calc.value = "";
		tax.innerText = getLocalizedString('Tax');
	}
	
	if (isNaN(floatValue) == false) {
		userEntry = floatValue;
		direction = side;
		calcValue = Math.round(((eval(floatValue+operation+(1+allRates[chosenRate].percent/100))))*100)/100;
		taxAmount = Math.abs(Math.round((calcValue-floatValue)*100)/100);
	}
	
	tax.innerText = taxAmount;
  calc.value = calcValue;
}

function storeRates() {
	var ratesStr = "[";

	for (var j = 0; j < allRates.length; j++) {
		var rateData = allRates[j];
		ratesStr += (j != 0) ? "," : "";
		var rateLabel = rateData.label.replace(/\'/g, "\\'");
		ratesStr += "{label:'" + rateLabel + "',percent:'" + rateData.percent + "'}";
	}
	ratesStr += "];";

	return ratesStr;
}

function saveRate() {
	var label = document.getElementById('input-label');
	var rate = document.getElementById('input-rate');
	var rateValue = rate.value.replace(',', '.');

	if (!isNaN(parseFloat(rateValue)) && label.value) {
		allRates[allRates.length] = {label: label.value, percent: rateValue};

		setRatesTable();
		if (window.widget) {
			widget.setPreferenceForKey(storeRates(),'storedRates');
		}
		label.value = rate.value = "";
	}
	listRates(chosenRate);
}

function setRatesTable() {
	var backList = document.getElementById('inner-list');
	removeAllChildren(backList);
	for (var i=0; i<allRates.length; i++) {
		var data = allRates[i];
		writeRow(data.label, data.percent);
	}
}

function rowClicked(w) {
	if (allRates.length > 1)
		genericButtonSetEnabled (document.getElementById('remove'), true);
	if (selectedRow != w) {
		if (selectedRow != null)
			selectedRow.setAttribute("class", "row");

		selectedRow = w;

		w.setAttribute ("class", "row select");
	}
}

function removeClicked() {
	if (selectedRow != null) {
		var ind = findIndexOfChild (selectedRow);
		allRates.splice (ind, 1);
		chosenRate = (chosenRate == ind) ? 0 : chosenRate;
		
		selectedRow.parentNode.removeChild(selectedRow);
		
		selectedRow = null;
	}
	
	genericButtonSetEnabled (document.getElementById('remove'), false);
	widget.setPreferenceForKey(storeRates(),'storedRates');
	
	listRates(chosenRate);
	applyRate();
}

function findIndexOfChild (child) {
	var node = child.parentNode;
	var i = 0;
	
	for (node = node.firstChild; node != null; node = node.nextSibling, ++i) {
		if (node == child)
			return i;
	}
	return -1;
}

function writeRow (label, percent) {
	var backList = document.getElementById('inner-list');
	
	var row = document.createElement('div');
	row.setAttribute("class", "row");
	row.setAttribute("onclick", "rowClicked(this);");
	
	var span = document.createElement('span');
	span.setAttribute ("class", "percent");
	span.innerText = writePercentLabel(percent);
	row.appendChild(span);
	
	span = document.createElement('span');
	span.setAttribute ("class", "label");
	span.innerText = label;
	row.appendChild(span);
	
	backList.appendChild(row);
	
	return row;
}

function removeAllChildren (parent) {
	while (parent.hasChildNodes())
		parent.removeChild(parent.firstChild);
}

function createKey (key) {
	return widget.identifier + "-" + key
}

function doneClicked(){
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget) {
		widget.prepareForTransition("ToFront");
	}

	back.style.display="none";
	front.style.display="block";

	if (window.widget){
		setTimeout ('widget.performTransition();', 0);
		window.resizeTo(368, 51);
	}
	mouseexit(event);
	exitflip(event)
}

function logoClicked(){
	if (window.widget){
		widget.openURL('http://www.ladybug.fr/');
	}
}

/* fade info button
------------------------------------------------ */
function getLocalizedString (key) {
	try {
		var ret = localizedStrings[key];
		if (ret === undefined)
			ret = key;
		return ret;
	} catch (ex) {}
	
	return key;
}

var flipShown = false;
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};

function mousemove (event) {
	if (!flipShown) {
		if (animation.timer != null) {
			clearInterval (animation.timer);
			animation.timer  = null;
		}
				
		var starttime = (new Date).getTime() - 13;
				
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.6;
		animate();
		flipShown = true;
	}
}

function mouseexit (event) {
	if (flipShown) {
		// fade in the info button
		if (animation.timer != null) {
			clearInterval (animation.timer);
			animation.timer  = null;
		}
				
		var starttime = (new Date).getTime() - 13;
				
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}

function animate() {
	var T;
	var ease;
	var time = (new Date).getTime();

	T = limit_3(time-animation.starttime, 0, animation.duration);

	if (T >= animation.duration) {
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else {
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}

	animation.firstElement.style.opacity = animation.now;
}

function limit_3 (a, b, c) {
	return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease) {
	return from + (to - from) * ease;
}

function enterflip(event) {
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event) {
	document.getElementById('fliprollie').style.display = 'none';
}


/* preferences flip
------------------------------------------------ */
// always check that we are running in Dashboard

function showPrefs() {
	var front = document.getElementById("front");
	var back = document.getElementById("back");

	if (window.widget) {
		window.resizeTo(368, 230);
		widget.prepareForTransition("ToBack");
	}

	backsideChanged = false;

	front.style.display="none";
	back.style.display="block";

	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
}

function hidePrefs() {
	var front = document.getElementById("front");
	var back = document.getElementById("back");
		
	if (window.widget) {
		widget.prepareForTransition("ToFront");
	}
		
	back.style.display="none";
	front.style.display="block";

	if (window.widget){
		setTimeout ('widget.performTransition();', 0);
		window.resizeTo(368, 51);
	}
}